/*
 * Created on Aug 20, 2003
 */
package Data;

import java.sql.*;
/**
 * @author student
 * This class is being used for getting and setting user information.
 * 
 */
public class UserData {
	static String loginId;
	private int ncbId;
	String fName;
	String lName;
	Timestamp outFrom;
	Timestamp outTo;
	//	Timestamp expiry;
	String contactNumber, emailAddress, mobileNumber;
	String password, verifier;

	/**
	 * This is the constructor for UserData.java
	 */
	public UserData() {
	}

	/**
	 * This is the constructor for UserData.java with parameters
	 */
	public UserData(
		String fName,
		String lName,
		String email,
		Timestamp outFrom,
		Timestamp outTo) {
		this.loginId = loginId;
		this.fName = fName;
		this.lName = lName;
		this.emailAddress = email;
		this.outFrom = outFrom;
		this.outTo = outTo;

	}

	/**
	 * This method is being used to get the login ID of the user.
	 * @param void
	 * @return String login Id of the user.
	 */
	public String getLoginId() {
		return loginId;
	}
	/**
	 * This method is being used to set the Login Id of the user
	 * @param String Login Id of the user.
	 * @return void
	 */
	public void setLoginId(String loginId) {
		UserData.loginId = loginId;
	}
	/**
	 * This method is being used to get the Ncb ID of the user.
	 * @param void
	 * @return int Ncb Id of the user.
	 */
	public int getNcbId() {
		return ncbId;
	}
	/**
	 * This method is being used to set the Ncb Id of the user
	 * @param String Ncb Id of the user.
	 * @return void
	 */
	public void setNcbId(int ncbId) {
		this.ncbId = ncbId;
	}

	/**
	 * This method is being used to get the contact number of the user.
	 * @param void
	 * @return String contact number of the user.
	 */
	public String getContactNumber() {
		return contactNumber;
	}
	/**
	 * This method is being used to set the contact number of the user
	 * @param String Contact number of the user.
	 * @return void
	 */
	public void setContactNumber(String contactNumber) {
		this.contactNumber = contactNumber;
	}
	/**
	 * This method is being used to get the mobile number of the user.
	 * @param void
	 * @return String Mobile number of the user.
	 */
	public String getMobileNumber() {
		return mobileNumber;
	}
	/**
	 * This method is being used to set the Mobile number of the user
	 * @param String Mobile number of the user.
	 * @return void
	 */
	public void setMobileNumber(String mobileNumber) {
		this.mobileNumber = mobileNumber;
	}
	/**
	 * This method is being used to get email address  of the user.
	 * @param void
	 * @return String Email Address of the user.
	 */
	public String getEmailAddress() {
		return emailAddress;
	}
		/**
	 * This method is being used to set the email address of the user
	 * @param String Email address of the user.
	 * @return void
	 */
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
	/**
	 * This method is being used to get the password of the user.
	 * @param void
	 * @return String Password of the user.
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * This method is being used to set the Password of the user
	 * @param String Password of the user.
	 * @return void
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 * This method is being used to get the password verifier of the user.
	 * @param void
	 * @return String Password Verifier of the user.
	 */
	public String getVerifier() {
		return verifier;
	}
	/**
	 * This method is being used to set the password Verifier of the user
	 * @param String Password Verifier of the user.
	 * @return void
	 */
	public void setVerifier(String verifier) {
		this.verifier = verifier;
	}

	/**
	 * This method is being used to get first name of the user.
	 * @param void
	 * @return String First name of the user.
	 */
	public String getFName() {
		return fName;
	}
	/**
	 * This method is being used to set the Firstname of the user
	 * @param String Firstname of the user.
	 * @return void
	 */
	public void setFName(String fName) {
		this.fName = fName;
	}
	/**
	 * This method is being used to get the last name of the user.
	 * @param void
	 * @return String Lastname of the user.
	 */
	public String getLName() {
		return lName;
	}
	/**
	 * This method is being used to set the Lastname of the user
	 * @param String Lastname of the user.
	 * @return void
	 */
	public void setLName(String lName) {
		this.lName = lName;
	}
	/**
	 * This method is being used to get the time the user is out from .
	 * @param void
	 * @return time Time the user is out from.
	 */
	public Timestamp getOutFrom() {
		return outFrom;
	}
	/**
	 * This method is being used to set the time the user is out from.
	 * @param time Time the user is out from.
	 * @return void
	 */
	public void setOutFrom(Timestamp outFrom) {
		this.outFrom = outFrom;
	}
	/**
	 * This method is being used to get the time the user is out untill.
	 * @param void
	 * @return time Time user is out untill.
	 */
	public Timestamp getOutTo() {
		return outTo;
	}
	/**
	 * This method is being used to set the time the user is out untill
	 * @param time Time the user is out untill.
	 * @return void
	 */
	public void setOutTo(Timestamp outTo) {
		this.outTo = outTo;
	}
	/**
	 * This method is being used to get the availability of the user.
	 * @param void
	 * @return String Cehcks if the user is In or Out.
	 */
	public String getInOut() {
		long currentTime = System.currentTimeMillis();
		Timestamp current = new Timestamp(currentTime);
		if (outTo == null)
			return "In";
		else if (outFrom.after(current))
			return "In";
		else if (outTo.after(current))
			return "Out";
		else
			return "In";

	}
}